/**
 * The main method demonstrates how to use a 
 * parameter
 * 
 * @author Zach Krasne
 */
import java.util.*; // to use Scanner
import java.io.*;  // to work with files
public class ConwayGame {
    public static int rowNum;
    public static int colNum;
    public static int gen;
    
    public static void main(String [] args) throws IOException {
        if (args.length == 0)
            System.out.println("You must enter a filename. Exiting.");
        else {
            String file = args[0];
            char[][] g = initGame(file);
            
            Scanner input = new Scanner(System.in);
            System.out.print("Please input the number of generations to calculate: ");
            int iter = input.nextInt();
            input.nextLine();
            System.out.print("\nShould the generations display continuously (Y/N): ");
            String display = input.nextLine();
            System.out.println();
            
            char[][] g1B = new char[rowNum][colNum];
            char[][] g2B = new char[rowNum][colNum];
            
            if (display.equalsIgnoreCase("Y")) {
                displayGrid(gen, g);
                System.out.println();
                while (gen < iter && cellCount(g) > 0 && notSame(g, g1B) && notSame(g, g2B)) {
                    g2B = g1B;
                    g1B = g;
                    g = nextGeneration(g);
                    displayGrid(gen, g);
                    System.out.println();
                }
                endMessage(iter, g, g1B, g2B);
            }
            else if (display.equalsIgnoreCase("N")) {
                displayGrid(gen, g);
                System.out.println("Please press enter for the next generation.");
                input.nextLine();
                while (gen < iter && cellCount(g) > 0 && notSame(g, g1B) && notSame(g, g2B)) {
                    g2B = g1B;
                    g1B = g;
                    g = nextGeneration(g);
                    displayGrid(gen, g);
                    System.out.println("\nPlease press enter for the next generation.");
                    input.nextLine();
                }
                endMessage(iter, g, g1B, g2B);
            }
            else {
                System.out.println("Improper input. Please start program again.");
            }
        }
    }
    
    public static char[][] initGame(String fileName) throws IOException {
        File inputFile = new File(fileName);
        Scanner input = new Scanner(inputFile);
        
        rowNum = input.nextInt();
        colNum = input.nextInt();
        gen = 0;
        
        char[][] grid = new char[rowNum][colNum];
        for (int i = 0; i < rowNum; i++) {
            for (int j = 0; j < colNum; j++) {
                grid[i][j] = ' ';
            }
        }
        
        int x = 0;
        int y = 0;
        while (input.hasNext()) {
            x = input.nextInt();
            y = input.nextInt();
            grid[x][y] = '*';
        }
        
        return grid;
    }
    
    public static void displayGrid(int gen, char[][] grid) {
        System.out.println("Generation " + gen + ": \n");
        for (int i = 0; i < rowNum; i++) {
            for (int j = 0; j < colNum; j++) {
                System.out.print(grid[i][j] + " ");
            }
            System.out.println();
        }
    }
    
    public static char[][] nextGeneration(char[][] currGen) {
        char[][] nextGen = new char[rowNum][colNum];
        gen++;
        
        int neigh;
        for (int i = 0; i < rowNum; i++) {
            for (int j = 0; j < colNum; j++) {
                neigh = neighbors(currGen, i, j);
                if (neigh == 3) {
                    nextGen[i][j] = '*';
                }
                else if (neigh == 2 && currGen[i][j] == '*') {
                    nextGen[i][j] = '*';
                }
                else {
                    nextGen[i][j] = ' ';
                }
            }
        }
        
        return nextGen;
    }
    
    private static int neighbors(char[][] gen, int r, int c) {
        int neigh = 0;
        if (r > 0) {
            if (gen[r-1][c] == '*') {
                neigh++;
            }
            if (c > 0 && gen[r-1][c-1] == '*') {
                neigh++;
            }
            if (c < colNum - 1 && gen[r-1][c+1] == '*') {
                neigh++;
            }
        }
        if (r < rowNum - 1) {
            if (gen[r+1][c] == '*') {
                neigh++;
            }
            if (c > 0 && gen[r+1][c-1] == '*') {
                neigh++;
            }
            if (c < colNum - 1 && gen[r+1][c+1] == '*') {
                neigh++;
            }
        }
        if (c > 0 && gen[r][c-1] == '*') {
            neigh++;
        }
        if (c < colNum - 1 && gen[r][c+1] == '*') {
            neigh++;
        }
        return neigh;
    }
    
    private static int cellCount(char[][] grid) {
        int numCells = 0;
        for (int i = 0; i < rowNum; i++) {
            for (int j = 0; j < colNum; j++) {
                if (grid[i][j] == '*') {
                    ++numCells;
                }
            }
        }
        return numCells;
    }
    
    private static boolean notSame(char[][] g, char[][] g1) {
        boolean cont = false;
        for (int i = 0; i < rowNum; i++) {
            for (int j = 0; j < colNum; j++) {
                if (g[i][j] != g1[i][j]) {
                    cont = true;
                    break;
                }
            }
            if (cont) {
                break;
            }
        }
        return cont;
    }
    
    private static void endMessage(int iter, char[][] g, char[][] g1, char[][] g2) {
        if (cellCount(g) == 0) {
            System.out.println("All of the cells died.");
        }
        else if (!notSame(g, g1)) {
            System.out.println("The cells are in a stable state.");
        }
        else if (!notSame(g, g2)) {
            System.out.println("The cells are in a 2-pattern loop.");
        }
        else {
            System.out.println("That's all the generations!");
        }
    }
}
